// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The kind of repository access credentials. </summary>
    public readonly partial struct RepositoryAccessKind : IEquatable<RepositoryAccessKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RepositoryAccessKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RepositoryAccessKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OAuthValue = "OAuth";
        private const string PATValue = "PAT";
        private const string AppValue = "App";

        /// <summary> OAuth. </summary>
        public static RepositoryAccessKind OAuth { get; } = new RepositoryAccessKind(OAuthValue);
        /// <summary> PAT. </summary>
        public static RepositoryAccessKind PAT { get; } = new RepositoryAccessKind(PATValue);
        /// <summary> App. </summary>
        public static RepositoryAccessKind App { get; } = new RepositoryAccessKind(AppValue);
        /// <summary> Determines if two <see cref="RepositoryAccessKind"/> values are the same. </summary>
        public static bool operator ==(RepositoryAccessKind left, RepositoryAccessKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RepositoryAccessKind"/> values are not the same. </summary>
        public static bool operator !=(RepositoryAccessKind left, RepositoryAccessKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RepositoryAccessKind"/>. </summary>
        public static implicit operator RepositoryAccessKind(string value) => new RepositoryAccessKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RepositoryAccessKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RepositoryAccessKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
