// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> What suggestions should be taken to complete the recommendation. </summary>
    public partial class RecommendedSuggestion
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RecommendedSuggestion"/>. </summary>
        /// <param name="suggestionTypeId"> Id of the suggestion type. </param>
        /// <param name="title"> Title of the suggestion. </param>
        /// <param name="description"> Description of the suggestion. </param>
        /// <param name="action"> Action of the suggestion. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="suggestionTypeId"/>, <paramref name="title"/>, <paramref name="description"/> or <paramref name="action"/> is null. </exception>
        public RecommendedSuggestion(string suggestionTypeId, string title, string description, string action)
        {
            Argument.AssertNotNull(suggestionTypeId, nameof(suggestionTypeId));
            Argument.AssertNotNull(title, nameof(title));
            Argument.AssertNotNull(description, nameof(description));
            Argument.AssertNotNull(action, nameof(action));

            SuggestionTypeId = suggestionTypeId;
            Title = title;
            Description = description;
            Action = action;
            AdditionalProperties = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="RecommendedSuggestion"/>. </summary>
        /// <param name="suggestionTypeId"> Id of the suggestion type. </param>
        /// <param name="title"> Title of the suggestion. </param>
        /// <param name="description"> Description of the suggestion. </param>
        /// <param name="action"> Action of the suggestion. </param>
        /// <param name="additionalProperties"> Collection of additional properties for the suggestion. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RecommendedSuggestion(string suggestionTypeId, string title, string description, string action, IDictionary<string, string> additionalProperties, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SuggestionTypeId = suggestionTypeId;
            Title = title;
            Description = description;
            Action = action;
            AdditionalProperties = additionalProperties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="RecommendedSuggestion"/> for deserialization. </summary>
        internal RecommendedSuggestion()
        {
        }

        /// <summary> Id of the suggestion type. </summary>
        [WirePath("suggestionTypeId")]
        public string SuggestionTypeId { get; set; }
        /// <summary> Title of the suggestion. </summary>
        [WirePath("title")]
        public string Title { get; set; }
        /// <summary> Description of the suggestion. </summary>
        [WirePath("description")]
        public string Description { get; set; }
        /// <summary> Action of the suggestion. </summary>
        [WirePath("action")]
        public string Action { get; set; }
        /// <summary> Collection of additional properties for the suggestion. </summary>
        [WirePath("additionalProperties")]
        public IDictionary<string, string> AdditionalProperties { get; set; }
    }
}
