// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Status of the item publication. </summary>
    public readonly partial struct PublicationStatus : IEquatable<PublicationStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PublicationStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PublicationStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string InProgressValue = "InProgress";

        /// <summary> The item publication succeeded. </summary>
        public static PublicationStatus Succeeded { get; } = new PublicationStatus(SucceededValue);
        /// <summary> The item publication failed. </summary>
        public static PublicationStatus Failed { get; } = new PublicationStatus(FailedValue);
        /// <summary> The item publication is in progress. </summary>
        public static PublicationStatus InProgress { get; } = new PublicationStatus(InProgressValue);
        /// <summary> Determines if two <see cref="PublicationStatus"/> values are the same. </summary>
        public static bool operator ==(PublicationStatus left, PublicationStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PublicationStatus"/> values are not the same. </summary>
        public static bool operator !=(PublicationStatus left, PublicationStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PublicationStatus"/>. </summary>
        public static implicit operator PublicationStatus(string value) => new PublicationStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PublicationStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PublicationStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
