// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The scope on which the user should have permissions, in order to be able to create connections. </summary>
    public readonly partial struct ProviderPermissionsScope : IEquatable<ProviderPermissionsScope>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ProviderPermissionsScope"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ProviderPermissionsScope(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SubscriptionValue = "Subscription";
        private const string ResourceGroupValue = "ResourceGroup";
        private const string WorkspaceValue = "Workspace";

        /// <summary> Subscription. </summary>
        public static ProviderPermissionsScope Subscription { get; } = new ProviderPermissionsScope(SubscriptionValue);
        /// <summary> ResourceGroup. </summary>
        public static ProviderPermissionsScope ResourceGroup { get; } = new ProviderPermissionsScope(ResourceGroupValue);
        /// <summary> Workspace. </summary>
        public static ProviderPermissionsScope Workspace { get; } = new ProviderPermissionsScope(WorkspaceValue);
        /// <summary> Determines if two <see cref="ProviderPermissionsScope"/> values are the same. </summary>
        public static bool operator ==(ProviderPermissionsScope left, ProviderPermissionsScope right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ProviderPermissionsScope"/> values are not the same. </summary>
        public static bool operator !=(ProviderPermissionsScope left, ProviderPermissionsScope right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ProviderPermissionsScope"/>. </summary>
        public static implicit operator ProviderPermissionsScope(string value) => new ProviderPermissionsScope(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ProviderPermissionsScope other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ProviderPermissionsScope other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
