// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Describes an automation rule condition that evaluates an array property's value. </summary>
    public partial class PropertyArrayConditionProperties : SecurityInsightsAutomationRuleCondition
    {
        /// <summary> Initializes a new instance of <see cref="PropertyArrayConditionProperties"/>. </summary>
        public PropertyArrayConditionProperties()
        {
            ConditionType = ConditionType.PropertyArray;
        }

        /// <summary> Initializes a new instance of <see cref="PropertyArrayConditionProperties"/>. </summary>
        /// <param name="conditionType"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="conditionProperties"></param>
        internal PropertyArrayConditionProperties(ConditionType conditionType, IDictionary<string, BinaryData> serializedAdditionalRawData, AutomationRulePropertyArrayValuesCondition conditionProperties) : base(conditionType, serializedAdditionalRawData)
        {
            ConditionProperties = conditionProperties;
            ConditionType = conditionType;
        }

        /// <summary> Gets or sets the condition properties. </summary>
        [WirePath("conditionProperties")]
        public AutomationRulePropertyArrayValuesCondition ConditionProperties { get; set; }
    }
}
