// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Permission provider scope. </summary>
    public readonly partial struct PermissionProviderScope : IEquatable<PermissionProviderScope>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PermissionProviderScope"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PermissionProviderScope(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ResourceGroupValue = "ResourceGroup";
        private const string SubscriptionValue = "Subscription";
        private const string WorkspaceValue = "Workspace";

        /// <summary> ResourceGroup. </summary>
        public static PermissionProviderScope ResourceGroup { get; } = new PermissionProviderScope(ResourceGroupValue);
        /// <summary> Subscription. </summary>
        public static PermissionProviderScope Subscription { get; } = new PermissionProviderScope(SubscriptionValue);
        /// <summary> Workspace. </summary>
        public static PermissionProviderScope Workspace { get; } = new PermissionProviderScope(WorkspaceValue);
        /// <summary> Determines if two <see cref="PermissionProviderScope"/> values are the same. </summary>
        public static bool operator ==(PermissionProviderScope left, PermissionProviderScope right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PermissionProviderScope"/> values are not the same. </summary>
        public static bool operator !=(PermissionProviderScope left, PermissionProviderScope right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PermissionProviderScope"/>. </summary>
        public static implicit operator PermissionProviderScope(string value) => new PermissionProviderScope(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PermissionProviderScope other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PermissionProviderScope other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
