// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Represents NRT alert rule. </summary>
    public partial class NrtAlertRule : SecurityInsightsAlertRuleData
    {
        /// <summary> Initializes a new instance of <see cref="NrtAlertRule"/>. </summary>
        public NrtAlertRule()
        {
            Tactics = new ChangeTrackingList<SecurityInsightsAttackTactic>();
            Techniques = new ChangeTrackingList<string>();
            SubTechniques = new ChangeTrackingList<string>();
            CustomDetails = new ChangeTrackingDictionary<string, string>();
            EntityMappings = new ChangeTrackingList<SecurityInsightsAlertRuleEntityMapping>();
            SentinelEntitiesMappings = new ChangeTrackingList<SentinelEntityMapping>();
            Kind = AlertRuleKind.NRT;
        }

        /// <summary> Initializes a new instance of <see cref="NrtAlertRule"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> The kind of the alert rule. </param>
        /// <param name="etag"> Etag of the azure resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="alertRuleTemplateName"> The Name of the alert rule template used to create this rule. </param>
        /// <param name="templateVersion"> The version of the alert rule template used to create this rule - in format &lt;a.b.c&gt;, where all are numbers, for example 0 &lt;1.0.2&gt;. </param>
        /// <param name="description"> The description of the alert rule. </param>
        /// <param name="query"> The query that creates alerts for this rule. </param>
        /// <param name="tactics"> The tactics of the alert rule. </param>
        /// <param name="techniques"> The techniques of the alert rule. </param>
        /// <param name="subTechniques"> The sub-techniques of the alert rule. </param>
        /// <param name="displayName"> The display name for alerts created by this alert rule. </param>
        /// <param name="isEnabled"> Determines whether this alert rule is enabled or disabled. </param>
        /// <param name="lastModifiedOn"> The last time that this alert rule has been modified. </param>
        /// <param name="suppressionDuration"> The suppression (in ISO 8601 duration format) to wait since last time this alert rule been triggered. </param>
        /// <param name="isSuppressionEnabled"> Determines whether the suppression for this alert rule is enabled or disabled. </param>
        /// <param name="severity"> The severity for alerts created by this alert rule. </param>
        /// <param name="incidentConfiguration"> The settings of the incidents that created from alerts triggered by this analytics rule. </param>
        /// <param name="customDetails"> Dictionary of string key-value pairs of columns to be attached to the alert. </param>
        /// <param name="entityMappings"> Array of the entity mappings of the alert rule. </param>
        /// <param name="alertDetailsOverride"> The alert details override settings. </param>
        /// <param name="eventGroupingSettings"> The event grouping settings. </param>
        /// <param name="sentinelEntitiesMappings"> Array of the sentinel entity mappings of the alert rule. </param>
        internal NrtAlertRule(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, AlertRuleKind kind, ETag? etag, IDictionary<string, BinaryData> serializedAdditionalRawData, string alertRuleTemplateName, string templateVersion, string description, string query, IList<SecurityInsightsAttackTactic> tactics, IList<string> techniques, IList<string> subTechniques, string displayName, bool? isEnabled, DateTimeOffset? lastModifiedOn, TimeSpan? suppressionDuration, bool? isSuppressionEnabled, SecurityInsightsAlertSeverity? severity, SecurityInsightsIncidentConfiguration incidentConfiguration, IDictionary<string, string> customDetails, IList<SecurityInsightsAlertRuleEntityMapping> entityMappings, SecurityInsightsAlertDetailsOverride alertDetailsOverride, EventGroupingSettings eventGroupingSettings, IList<SentinelEntityMapping> sentinelEntitiesMappings) : base(id, name, resourceType, systemData, kind, etag, serializedAdditionalRawData)
        {
            AlertRuleTemplateName = alertRuleTemplateName;
            TemplateVersion = templateVersion;
            Description = description;
            Query = query;
            Tactics = tactics;
            Techniques = techniques;
            SubTechniques = subTechniques;
            DisplayName = displayName;
            IsEnabled = isEnabled;
            LastModifiedOn = lastModifiedOn;
            SuppressionDuration = suppressionDuration;
            IsSuppressionEnabled = isSuppressionEnabled;
            Severity = severity;
            IncidentConfiguration = incidentConfiguration;
            CustomDetails = customDetails;
            EntityMappings = entityMappings;
            AlertDetailsOverride = alertDetailsOverride;
            EventGroupingSettings = eventGroupingSettings;
            SentinelEntitiesMappings = sentinelEntitiesMappings;
            Kind = kind;
        }

        /// <summary> The Name of the alert rule template used to create this rule. </summary>
        [WirePath("properties.alertRuleTemplateName")]
        public string AlertRuleTemplateName { get; set; }
        /// <summary> The version of the alert rule template used to create this rule - in format &lt;a.b.c&gt;, where all are numbers, for example 0 &lt;1.0.2&gt;. </summary>
        [WirePath("properties.templateVersion")]
        public string TemplateVersion { get; set; }
        /// <summary> The description of the alert rule. </summary>
        [WirePath("properties.description")]
        public string Description { get; set; }
        /// <summary> The query that creates alerts for this rule. </summary>
        [WirePath("properties.query")]
        public string Query { get; set; }
        /// <summary> The tactics of the alert rule. </summary>
        [WirePath("properties.tactics")]
        public IList<SecurityInsightsAttackTactic> Tactics { get; }
        /// <summary> The techniques of the alert rule. </summary>
        [WirePath("properties.techniques")]
        public IList<string> Techniques { get; }
        /// <summary> The sub-techniques of the alert rule. </summary>
        [WirePath("properties.subTechniques")]
        public IList<string> SubTechniques { get; }
        /// <summary> The display name for alerts created by this alert rule. </summary>
        [WirePath("properties.displayName")]
        public string DisplayName { get; set; }
        /// <summary> Determines whether this alert rule is enabled or disabled. </summary>
        [WirePath("properties.enabled")]
        public bool? IsEnabled { get; set; }
        /// <summary> The last time that this alert rule has been modified. </summary>
        [WirePath("properties.lastModifiedUtc")]
        public DateTimeOffset? LastModifiedOn { get; }
        /// <summary> The suppression (in ISO 8601 duration format) to wait since last time this alert rule been triggered. </summary>
        [WirePath("properties.suppressionDuration")]
        public TimeSpan? SuppressionDuration { get; set; }
        /// <summary> Determines whether the suppression for this alert rule is enabled or disabled. </summary>
        [WirePath("properties.suppressionEnabled")]
        public bool? IsSuppressionEnabled { get; set; }
        /// <summary> The severity for alerts created by this alert rule. </summary>
        [WirePath("properties.severity")]
        public SecurityInsightsAlertSeverity? Severity { get; set; }
        /// <summary> The settings of the incidents that created from alerts triggered by this analytics rule. </summary>
        [WirePath("properties.incidentConfiguration")]
        public SecurityInsightsIncidentConfiguration IncidentConfiguration { get; set; }
        /// <summary> Dictionary of string key-value pairs of columns to be attached to the alert. </summary>
        [WirePath("properties.customDetails")]
        public IDictionary<string, string> CustomDetails { get; }
        /// <summary> Array of the entity mappings of the alert rule. </summary>
        [WirePath("properties.entityMappings")]
        public IList<SecurityInsightsAlertRuleEntityMapping> EntityMappings { get; }
        /// <summary> The alert details override settings. </summary>
        [WirePath("properties.alertDetailsOverride")]
        public SecurityInsightsAlertDetailsOverride AlertDetailsOverride { get; set; }
        /// <summary> The event grouping settings. </summary>
        internal EventGroupingSettings EventGroupingSettings { get; set; }
        /// <summary> The event grouping aggregation kinds. </summary>
        [WirePath("properties.eventGroupingSettings.aggregationKind")]
        public EventGroupingAggregationKind? EventGroupingAggregationKind
        {
            get => EventGroupingSettings is null ? default : EventGroupingSettings.AggregationKind;
            set
            {
                if (EventGroupingSettings is null)
                    EventGroupingSettings = new EventGroupingSettings();
                EventGroupingSettings.AggregationKind = value;
            }
        }

        /// <summary> Array of the sentinel entity mappings of the alert rule. </summary>
        [WirePath("properties.sentinelEntitiesMappings")]
        public IList<SentinelEntityMapping> SentinelEntitiesMappings { get; }
    }
}
