// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The available data types for MCAS (Microsoft Cloud App Security) data connector. </summary>
    public partial class McasDataConnectorDataTypes : SecurityInsightsAlertsDataTypeOfDataConnector
    {
        /// <summary> Initializes a new instance of <see cref="McasDataConnectorDataTypes"/>. </summary>
        /// <param name="alerts"> Alerts data type connection. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="alerts"/> is null. </exception>
        public McasDataConnectorDataTypes(DataConnectorDataTypeCommon alerts) : base(alerts)
        {
            Argument.AssertNotNull(alerts, nameof(alerts));
        }

        /// <summary> Initializes a new instance of <see cref="McasDataConnectorDataTypes"/>. </summary>
        /// <param name="alerts"> Alerts data type connection. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="discoveryLogs"> Discovery log data type connection. </param>
        internal McasDataConnectorDataTypes(DataConnectorDataTypeCommon alerts, IDictionary<string, BinaryData> serializedAdditionalRawData, DataConnectorDataTypeCommon discoveryLogs) : base(alerts, serializedAdditionalRawData)
        {
            DiscoveryLogs = discoveryLogs;
        }

        /// <summary> Discovery log data type connection. </summary>
        internal DataConnectorDataTypeCommon DiscoveryLogs { get; set; }
        /// <summary> Describe whether this data type connection is enabled or not. </summary>
        [WirePath("discoveryLogs.state")]
        public SecurityInsightsDataTypeConnectionState? DiscoveryLogsState
        {
            get => DiscoveryLogs is null ? default(SecurityInsightsDataTypeConnectionState?) : DiscoveryLogs.State;
            set
            {
                DiscoveryLogs = value.HasValue ? new DataConnectorDataTypeCommon(value.Value) : null;
            }
        }
    }
}
