// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The ManualTriggerRequestBody. </summary>
    public partial class ManualTriggerRequestBody
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ManualTriggerRequestBody"/>. </summary>
        /// <param name="logicAppsResourceId"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="logicAppsResourceId"/> is null. </exception>
        public ManualTriggerRequestBody(string logicAppsResourceId)
        {
            Argument.AssertNotNull(logicAppsResourceId, nameof(logicAppsResourceId));

            LogicAppsResourceId = logicAppsResourceId;
        }

        /// <summary> Initializes a new instance of <see cref="ManualTriggerRequestBody"/>. </summary>
        /// <param name="tenantId"></param>
        /// <param name="logicAppsResourceId"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ManualTriggerRequestBody(Guid? tenantId, string logicAppsResourceId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TenantId = tenantId;
            LogicAppsResourceId = logicAppsResourceId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ManualTriggerRequestBody"/> for deserialization. </summary>
        internal ManualTriggerRequestBody()
        {
        }

        /// <summary> Gets or sets the tenant id. </summary>
        [WirePath("tenantId")]
        public Guid? TenantId { get; set; }
        /// <summary> Gets the logic apps resource id. </summary>
        [WirePath("logicAppsResourceId")]
        public string LogicAppsResourceId { get; }
    }
}
