// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Data type for last data received. </summary>
    public partial class LastDataReceivedDataType
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LastDataReceivedDataType"/>. </summary>
        public LastDataReceivedDataType()
        {
        }

        /// <summary> Initializes a new instance of <see cref="LastDataReceivedDataType"/>. </summary>
        /// <param name="name"> Name of the data type to show in the graph. can be use with {{graphQueriesTableName}} placeholder. </param>
        /// <param name="lastDataReceivedQuery"> Query for indicate last data received. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LastDataReceivedDataType(string name, string lastDataReceivedQuery, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            LastDataReceivedQuery = lastDataReceivedQuery;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the data type to show in the graph. can be use with {{graphQueriesTableName}} placeholder. </summary>
        [WirePath("name")]
        public string Name { get; set; }
        /// <summary> Query for indicate last data received. </summary>
        [WirePath("lastDataReceivedQuery")]
        public string LastDataReceivedQuery { get; set; }
    }
}
