// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> An entity describing the publish status of a content item. </summary>
    public partial class JobItem
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="JobItem"/>. </summary>
        public JobItem()
        {
            Errors = new ChangeTrackingList<PublicationFailedError>();
        }

        /// <summary> Initializes a new instance of <see cref="JobItem"/>. </summary>
        /// <param name="resourceId"> The resource id of the content item. </param>
        /// <param name="status"> Status of the item publication. </param>
        /// <param name="executionOn"> The time the item publishing was completed. </param>
        /// <param name="errors"> The list of error descriptions if the item publication fails. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal JobItem(ResourceIdentifier resourceId, PublicationStatus? status, DateTimeOffset? executionOn, IList<PublicationFailedError> errors, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ResourceId = resourceId;
            Status = status;
            ExecutionOn = executionOn;
            Errors = errors;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The resource id of the content item. </summary>
        [WirePath("resourceId")]
        public ResourceIdentifier ResourceId { get; set; }
        /// <summary> Status of the item publication. </summary>
        [WirePath("status")]
        public PublicationStatus? Status { get; }
        /// <summary> The time the item publishing was completed. </summary>
        [WirePath("executionTime")]
        public DateTimeOffset? ExecutionOn { get; }
        /// <summary> The list of error descriptions if the item publication fails. </summary>
        [WirePath("errors")]
        public IList<PublicationFailedError> Errors { get; }
    }
}
