// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Represents IoT requirements check request. </summary>
    public partial class IotCheckRequirements : DataConnectorsCheckRequirements
    {
        /// <summary> Initializes a new instance of <see cref="IotCheckRequirements"/>. </summary>
        public IotCheckRequirements()
        {
            Kind = DataConnectorKind.IOT;
        }

        /// <summary> Initializes a new instance of <see cref="IotCheckRequirements"/>. </summary>
        /// <param name="kind"> Describes the kind of connector to be checked. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="subscriptionId"> The subscription id to connect to, and get the data from. </param>
        internal IotCheckRequirements(DataConnectorKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, string subscriptionId) : base(kind, serializedAdditionalRawData)
        {
            SubscriptionId = subscriptionId;
            Kind = kind;
        }

        /// <summary> The subscription id to connect to, and get the data from. </summary>
        [WirePath("properties.subscriptionId")]
        public string SubscriptionId { get; set; }
    }
}
