// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Instruction steps to enable the connector. </summary>
    public partial class InstructionSteps
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="InstructionSteps"/>. </summary>
        public InstructionSteps()
        {
            Instructions = new ChangeTrackingList<ConnectorInstructionModelBase>();
        }

        /// <summary> Initializes a new instance of <see cref="InstructionSteps"/>. </summary>
        /// <param name="title"> Instruction step title. </param>
        /// <param name="description"> Instruction step description. </param>
        /// <param name="instructions"> Instruction step details. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal InstructionSteps(string title, string description, IList<ConnectorInstructionModelBase> instructions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Title = title;
            Description = description;
            Instructions = instructions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Instruction step title. </summary>
        [WirePath("title")]
        public string Title { get; set; }
        /// <summary> Instruction step description. </summary>
        [WirePath("description")]
        public string Description { get; set; }
        /// <summary> Instruction step details. </summary>
        [WirePath("instructions")]
        public IList<ConnectorInstructionModelBase> Instructions { get; }
    }
}
