// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Instruction step details, to be displayed in the Instructions steps section in the connector's page in Sentinel Portal. </summary>
    public partial class InstructionStepDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="InstructionStepDetails"/>. </summary>
        /// <param name="parameters"> Gets or sets the instruction type parameters settings. </param>
        /// <param name="instructionStepDetailsType"> Gets or sets the instruction type name. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="parameters"/> or <paramref name="instructionStepDetailsType"/> is null. </exception>
        public InstructionStepDetails(BinaryData parameters, string instructionStepDetailsType)
        {
            Argument.AssertNotNull(parameters, nameof(parameters));
            Argument.AssertNotNull(instructionStepDetailsType, nameof(instructionStepDetailsType));

            Parameters = parameters;
            InstructionStepDetailsType = instructionStepDetailsType;
        }

        /// <summary> Initializes a new instance of <see cref="InstructionStepDetails"/>. </summary>
        /// <param name="parameters"> Gets or sets the instruction type parameters settings. </param>
        /// <param name="instructionStepDetailsType"> Gets or sets the instruction type name. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal InstructionStepDetails(BinaryData parameters, string instructionStepDetailsType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Parameters = parameters;
            InstructionStepDetailsType = instructionStepDetailsType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="InstructionStepDetails"/> for deserialization. </summary>
        internal InstructionStepDetails()
        {
        }

        /// <summary>
        /// Gets or sets the instruction type parameters settings.
        /// <para>
        /// To assign an object to this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        [WirePath("parameters")]
        public BinaryData Parameters { get; set; }
        /// <summary> Gets or sets the instruction type name. </summary>
        [WirePath("type")]
        public string InstructionStepDetailsType { get; set; }
    }
}
