// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Instruction steps to enable the connector. </summary>
    public partial class InstructionStep
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="InstructionStep"/>. </summary>
        public InstructionStep()
        {
            Instructions = new ChangeTrackingList<InstructionStepDetails>();
            InnerSteps = new ChangeTrackingList<InstructionStep>();
        }

        /// <summary> Initializes a new instance of <see cref="InstructionStep"/>. </summary>
        /// <param name="title"> Gets or sets the instruction step title. </param>
        /// <param name="description"> Gets or sets the instruction step description. </param>
        /// <param name="instructions"> Gets or sets the instruction step details. </param>
        /// <param name="innerSteps">
        /// Gets or sets the inner instruction steps details.
        /// Foe Example: instruction step 1 might contain inner instruction steps: [instruction step 1.1, instruction step 1.2].
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal InstructionStep(string title, string description, IList<InstructionStepDetails> instructions, IList<InstructionStep> innerSteps, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Title = title;
            Description = description;
            Instructions = instructions;
            InnerSteps = innerSteps;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the instruction step title. </summary>
        [WirePath("title")]
        public string Title { get; set; }
        /// <summary> Gets or sets the instruction step description. </summary>
        [WirePath("description")]
        public string Description { get; set; }
        /// <summary> Gets or sets the instruction step details. </summary>
        [WirePath("instructions")]
        public IList<InstructionStepDetails> Instructions { get; }
        /// <summary>
        /// Gets or sets the inner instruction steps details.
        /// Foe Example: instruction step 1 might contain inner instruction steps: [instruction step 1.1, instruction step 1.2].
        /// </summary>
        [WirePath("innerSteps")]
        public IList<InstructionStep> InnerSteps { get; }
    }
}
