// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem. </summary>
    public partial class InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem"/>. </summary>
        internal InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem()
        {
        }

        /// <summary> Initializes a new instance of <see cref="InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem"/>. </summary>
        /// <param name="projectedName"> Insight Link Definition Projected Name. </param>
        /// <param name="query"> Insight Link Definition Query. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem(string projectedName, string query, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProjectedName = projectedName;
            Query = query;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Insight Link Definition Projected Name. </summary>
        [WirePath("projectedName")]
        public string ProjectedName { get; }
        /// <summary> Insight Link Definition Query. </summary>
        [WirePath("Query")]
        public string Query { get; }
    }
}
