// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    public partial class InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem : IUtf8JsonSerializable, IJsonModel<InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ProjectedName))
            {
                writer.WritePropertyName("projectedName"u8);
                writer.WriteStringValue(ProjectedName);
            }
            if (Optional.IsDefined(Query))
            {
                writer.WritePropertyName("Query"u8);
                writer.WriteStringValue(Query);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem IJsonModel<InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeInsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem(document.RootElement, options);
        }

        internal static InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem DeserializeInsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string projectedName = default;
            string query = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("projectedName"u8))
                {
                    projectedName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("Query"u8))
                {
                    query = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem(projectedName, query, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProjectedName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  projectedName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProjectedName))
                {
                    builder.Append("  projectedName: ");
                    if (ProjectedName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ProjectedName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ProjectedName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Query), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  Query: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Query))
                {
                    builder.Append("  Query: ");
                    if (Query.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Query}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Query}'");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem)} does not support writing '{options.Format}' format.");
            }
        }

        InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem IPersistableModel<InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeInsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
