// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    public partial class InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem : IUtf8JsonSerializable, IJsonModel<InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Filter))
            {
                writer.WritePropertyName("filter"u8);
                writer.WriteStringValue(Filter);
            }
            if (Optional.IsDefined(Summarize))
            {
                writer.WritePropertyName("summarize"u8);
                writer.WriteStringValue(Summarize);
            }
            if (Optional.IsDefined(Project))
            {
                writer.WritePropertyName("project"u8);
                writer.WriteStringValue(Project);
            }
            if (Optional.IsCollectionDefined(LinkColumnsDefinitions))
            {
                writer.WritePropertyName("linkColumnsDefinitions"u8);
                writer.WriteStartArray();
                foreach (var item in LinkColumnsDefinitions)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem IJsonModel<InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeInsightQueryItemPropertiesTableQueryQueriesDefinitionsItem(document.RootElement, options);
        }

        internal static InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem DeserializeInsightQueryItemPropertiesTableQueryQueriesDefinitionsItem(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string filter = default;
            string summarize = default;
            string project = default;
            IReadOnlyList<InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem> linkColumnsDefinitions = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("filter"u8))
                {
                    filter = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("summarize"u8))
                {
                    summarize = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("project"u8))
                {
                    project = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("linkColumnsDefinitions"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem> array = new List<InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem.DeserializeInsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem(item, options));
                    }
                    linkColumnsDefinitions = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem(filter, summarize, project, linkColumnsDefinitions ?? new ChangeTrackingList<InsightQueryItemPropertiesTableQueryQueriesDefinitionsPropertiesItemsItem>(), serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Filter), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  filter: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Filter))
                {
                    builder.Append("  filter: ");
                    if (Filter.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Filter}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Filter}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Summarize), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  summarize: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Summarize))
                {
                    builder.Append("  summarize: ");
                    if (Summarize.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Summarize}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Summarize}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Project), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  project: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Project))
                {
                    builder.Append("  project: ");
                    if (Project.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Project}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Project}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LinkColumnsDefinitions), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  linkColumnsDefinitions: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(LinkColumnsDefinitions))
                {
                    if (LinkColumnsDefinitions.Any())
                    {
                        builder.Append("  linkColumnsDefinitions: ");
                        builder.AppendLine("[");
                        foreach (var item in LinkColumnsDefinitions)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  linkColumnsDefinitions: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem)} does not support writing '{options.Format}' format.");
            }
        }

        InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem IPersistableModel<InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeInsightQueryItemPropertiesTableQueryQueriesDefinitionsItem(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
