// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    public partial class InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem : IUtf8JsonSerializable, IJsonModel<InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Header))
            {
                writer.WritePropertyName("header"u8);
                writer.WriteStringValue(Header);
            }
            if (Optional.IsDefined(OutputType))
            {
                writer.WritePropertyName("outputType"u8);
                writer.WriteStringValue(OutputType.Value.ToString());
            }
            if (Optional.IsDefined(IsDeepLinkSupported))
            {
                writer.WritePropertyName("supportDeepLink"u8);
                writer.WriteBooleanValue(IsDeepLinkSupported.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem IJsonModel<InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeInsightQueryItemPropertiesTableQueryColumnsDefinitionsItem(document.RootElement, options);
        }

        internal static InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem DeserializeInsightQueryItemPropertiesTableQueryColumnsDefinitionsItem(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string header = default;
            InsightsColumnOutputType? outputType = default;
            bool? supportDeepLink = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("header"u8))
                {
                    header = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("outputType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    outputType = new InsightsColumnOutputType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("supportDeepLink"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    supportDeepLink = property.Value.GetBoolean();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem(header, outputType, supportDeepLink, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Header), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  header: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Header))
                {
                    builder.Append("  header: ");
                    if (Header.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Header}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Header}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OutputType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  outputType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(OutputType))
                {
                    builder.Append("  outputType: ");
                    builder.AppendLine($"'{OutputType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsDeepLinkSupported), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  supportDeepLink: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsDeepLinkSupported))
                {
                    builder.Append("  supportDeepLink: ");
                    var boolValue = IsDeepLinkSupported.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem)} does not support writing '{options.Format}' format.");
            }
        }

        InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem IPersistableModel<InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeInsightQueryItemPropertiesTableQueryColumnsDefinitionsItem(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
