// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    public partial class InsightQueryItemPropertiesTableQuery : IUtf8JsonSerializable, IJsonModel<InsightQueryItemPropertiesTableQuery>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<InsightQueryItemPropertiesTableQuery>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<InsightQueryItemPropertiesTableQuery>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InsightQueryItemPropertiesTableQuery>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InsightQueryItemPropertiesTableQuery)} does not support writing '{format}' format.");
            }

            if (Optional.IsCollectionDefined(ColumnsDefinitions))
            {
                writer.WritePropertyName("columnsDefinitions"u8);
                writer.WriteStartArray();
                foreach (var item in ColumnsDefinitions)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(QueriesDefinitions))
            {
                writer.WritePropertyName("queriesDefinitions"u8);
                writer.WriteStartArray();
                foreach (var item in QueriesDefinitions)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        InsightQueryItemPropertiesTableQuery IJsonModel<InsightQueryItemPropertiesTableQuery>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InsightQueryItemPropertiesTableQuery>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InsightQueryItemPropertiesTableQuery)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeInsightQueryItemPropertiesTableQuery(document.RootElement, options);
        }

        internal static InsightQueryItemPropertiesTableQuery DeserializeInsightQueryItemPropertiesTableQuery(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem> columnsDefinitions = default;
            IReadOnlyList<InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem> queriesDefinitions = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("columnsDefinitions"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem> array = new List<InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem.DeserializeInsightQueryItemPropertiesTableQueryColumnsDefinitionsItem(item, options));
                    }
                    columnsDefinitions = array;
                    continue;
                }
                if (property.NameEquals("queriesDefinitions"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem> array = new List<InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem.DeserializeInsightQueryItemPropertiesTableQueryQueriesDefinitionsItem(item, options));
                    }
                    queriesDefinitions = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new InsightQueryItemPropertiesTableQuery(columnsDefinitions ?? new ChangeTrackingList<InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem>(), queriesDefinitions ?? new ChangeTrackingList<InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem>(), serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ColumnsDefinitions), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  columnsDefinitions: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(ColumnsDefinitions))
                {
                    if (ColumnsDefinitions.Any())
                    {
                        builder.Append("  columnsDefinitions: ");
                        builder.AppendLine("[");
                        foreach (var item in ColumnsDefinitions)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  columnsDefinitions: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(QueriesDefinitions), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  queriesDefinitions: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(QueriesDefinitions))
                {
                    if (QueriesDefinitions.Any())
                    {
                        builder.Append("  queriesDefinitions: ");
                        builder.AppendLine("[");
                        foreach (var item in QueriesDefinitions)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  queriesDefinitions: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<InsightQueryItemPropertiesTableQuery>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InsightQueryItemPropertiesTableQuery>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(InsightQueryItemPropertiesTableQuery)} does not support writing '{options.Format}' format.");
            }
        }

        InsightQueryItemPropertiesTableQuery IPersistableModel<InsightQueryItemPropertiesTableQuery>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InsightQueryItemPropertiesTableQuery>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeInsightQueryItemPropertiesTableQuery(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(InsightQueryItemPropertiesTableQuery)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<InsightQueryItemPropertiesTableQuery>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
