// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The insight chart query. </summary>
    public partial class InsightQueryItemPropertiesDefaultTimeRange
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="InsightQueryItemPropertiesDefaultTimeRange"/>. </summary>
        internal InsightQueryItemPropertiesDefaultTimeRange()
        {
        }

        /// <summary> Initializes a new instance of <see cref="InsightQueryItemPropertiesDefaultTimeRange"/>. </summary>
        /// <param name="beforeRange"> The padding for the start time of the query. </param>
        /// <param name="afterRange"> The padding for the end time of the query. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal InsightQueryItemPropertiesDefaultTimeRange(string beforeRange, string afterRange, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            BeforeRange = beforeRange;
            AfterRange = afterRange;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The padding for the start time of the query. </summary>
        [WirePath("beforeRange")]
        public string BeforeRange { get; }
        /// <summary> The padding for the end time of the query. </summary>
        [WirePath("afterRange")]
        public string AfterRange { get; }
    }
}
