// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Represents Insight Query. </summary>
    public partial class InsightQueryItemProperties : EntityQueryItemProperties
    {
        /// <summary> Initializes a new instance of <see cref="InsightQueryItemProperties"/>. </summary>
        internal InsightQueryItemProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="InsightQueryItemProperties"/>. </summary>
        /// <param name="dataTypes"> Data types for template. </param>
        /// <param name="inputEntityType"> The type of the entity. </param>
        /// <param name="requiredInputFieldsSets"> Data types for template. </param>
        /// <param name="entitiesFilter"> The query applied only to entities matching to all filters. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="displayName"> The insight display name. </param>
        /// <param name="description"> The insight description. </param>
        /// <param name="baseQuery"> The base query of the insight. </param>
        /// <param name="tableQuery"> The insight table query. </param>
        /// <param name="chartQuery"> The insight chart query. </param>
        /// <param name="additionalQuery"> The activity query definitions. </param>
        /// <param name="defaultTimeRange"> The insight chart query. </param>
        /// <param name="referenceTimeRange"> The insight chart query. </param>
        internal InsightQueryItemProperties(IReadOnlyList<EntityQueryItemPropertiesDataTypesItem> dataTypes, SecurityInsightsEntityType? inputEntityType, IReadOnlyList<IList<string>> requiredInputFieldsSets, BinaryData entitiesFilter, IDictionary<string, BinaryData> serializedAdditionalRawData, string displayName, string description, string baseQuery, InsightQueryItemPropertiesTableQuery tableQuery, BinaryData chartQuery, InsightQueryItemPropertiesAdditionalQuery additionalQuery, InsightQueryItemPropertiesDefaultTimeRange defaultTimeRange, InsightQueryItemPropertiesReferenceTimeRange referenceTimeRange) : base(dataTypes, inputEntityType, requiredInputFieldsSets, entitiesFilter, serializedAdditionalRawData)
        {
            DisplayName = displayName;
            Description = description;
            BaseQuery = baseQuery;
            TableQuery = tableQuery;
            ChartQuery = chartQuery;
            AdditionalQuery = additionalQuery;
            DefaultTimeRange = defaultTimeRange;
            ReferenceTimeRange = referenceTimeRange;
        }

        /// <summary> The insight display name. </summary>
        [WirePath("displayName")]
        public string DisplayName { get; }
        /// <summary> The insight description. </summary>
        [WirePath("description")]
        public string Description { get; }
        /// <summary> The base query of the insight. </summary>
        [WirePath("baseQuery")]
        public string BaseQuery { get; }
        /// <summary> The insight table query. </summary>
        [WirePath("tableQuery")]
        public InsightQueryItemPropertiesTableQuery TableQuery { get; }
        /// <summary>
        /// The insight chart query.
        /// <para>
        /// To assign an object to this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        [WirePath("chartQuery")]
        public BinaryData ChartQuery { get; }
        /// <summary> The activity query definitions. </summary>
        [WirePath("additionalQuery")]
        public InsightQueryItemPropertiesAdditionalQuery AdditionalQuery { get; }
        /// <summary> The insight chart query. </summary>
        [WirePath("defaultTimeRange")]
        public InsightQueryItemPropertiesDefaultTimeRange DefaultTimeRange { get; }
        /// <summary> The insight chart query. </summary>
        internal InsightQueryItemPropertiesReferenceTimeRange ReferenceTimeRange { get; }
        /// <summary> Additional query time for looking back. </summary>
        [WirePath("referenceTimeRange.beforeRange")]
        public string BeforeRange
        {
            get => ReferenceTimeRange?.BeforeRange;
        }
    }
}
