// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    public partial class InsightQueryItemProperties : IUtf8JsonSerializable, IJsonModel<InsightQueryItemProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<InsightQueryItemProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<InsightQueryItemProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InsightQueryItemProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InsightQueryItemProperties)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(DisplayName))
            {
                writer.WritePropertyName("displayName"u8);
                writer.WriteStringValue(DisplayName);
            }
            if (Optional.IsDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStringValue(Description);
            }
            if (Optional.IsDefined(BaseQuery))
            {
                writer.WritePropertyName("baseQuery"u8);
                writer.WriteStringValue(BaseQuery);
            }
            if (Optional.IsDefined(TableQuery))
            {
                writer.WritePropertyName("tableQuery"u8);
                writer.WriteObjectValue(TableQuery, options);
            }
            if (Optional.IsDefined(ChartQuery))
            {
                writer.WritePropertyName("chartQuery"u8);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(ChartQuery);
#else
                using (JsonDocument document = JsonDocument.Parse(ChartQuery))
                {
                    JsonSerializer.Serialize(writer, document.RootElement);
                }
#endif
            }
            if (Optional.IsDefined(AdditionalQuery))
            {
                writer.WritePropertyName("additionalQuery"u8);
                writer.WriteObjectValue(AdditionalQuery, options);
            }
            if (Optional.IsDefined(DefaultTimeRange))
            {
                writer.WritePropertyName("defaultTimeRange"u8);
                writer.WriteObjectValue(DefaultTimeRange, options);
            }
            if (Optional.IsDefined(ReferenceTimeRange))
            {
                writer.WritePropertyName("referenceTimeRange"u8);
                writer.WriteObjectValue(ReferenceTimeRange, options);
            }
        }

        InsightQueryItemProperties IJsonModel<InsightQueryItemProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InsightQueryItemProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(InsightQueryItemProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeInsightQueryItemProperties(document.RootElement, options);
        }

        internal static InsightQueryItemProperties DeserializeInsightQueryItemProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string displayName = default;
            string description = default;
            string baseQuery = default;
            InsightQueryItemPropertiesTableQuery tableQuery = default;
            BinaryData chartQuery = default;
            InsightQueryItemPropertiesAdditionalQuery additionalQuery = default;
            InsightQueryItemPropertiesDefaultTimeRange defaultTimeRange = default;
            InsightQueryItemPropertiesReferenceTimeRange referenceTimeRange = default;
            IReadOnlyList<EntityQueryItemPropertiesDataTypesItem> dataTypes = default;
            SecurityInsightsEntityType? inputEntityType = default;
            IReadOnlyList<IList<string>> requiredInputFieldsSets = default;
            BinaryData entitiesFilter = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("displayName"u8))
                {
                    displayName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("description"u8))
                {
                    description = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("baseQuery"u8))
                {
                    baseQuery = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("tableQuery"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    tableQuery = InsightQueryItemPropertiesTableQuery.DeserializeInsightQueryItemPropertiesTableQuery(property.Value, options);
                    continue;
                }
                if (property.NameEquals("chartQuery"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    chartQuery = BinaryData.FromString(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("additionalQuery"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    additionalQuery = InsightQueryItemPropertiesAdditionalQuery.DeserializeInsightQueryItemPropertiesAdditionalQuery(property.Value, options);
                    continue;
                }
                if (property.NameEquals("defaultTimeRange"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    defaultTimeRange = InsightQueryItemPropertiesDefaultTimeRange.DeserializeInsightQueryItemPropertiesDefaultTimeRange(property.Value, options);
                    continue;
                }
                if (property.NameEquals("referenceTimeRange"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    referenceTimeRange = InsightQueryItemPropertiesReferenceTimeRange.DeserializeInsightQueryItemPropertiesReferenceTimeRange(property.Value, options);
                    continue;
                }
                if (property.NameEquals("dataTypes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<EntityQueryItemPropertiesDataTypesItem> array = new List<EntityQueryItemPropertiesDataTypesItem>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(EntityQueryItemPropertiesDataTypesItem.DeserializeEntityQueryItemPropertiesDataTypesItem(item, options));
                    }
                    dataTypes = array;
                    continue;
                }
                if (property.NameEquals("inputEntityType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    inputEntityType = new SecurityInsightsEntityType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("requiredInputFieldsSets"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<IList<string>> array = new List<IList<string>>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        if (item.ValueKind == JsonValueKind.Null)
                        {
                            array.Add(null);
                        }
                        else
                        {
                            List<string> array0 = new List<string>();
                            foreach (var item0 in item.EnumerateArray())
                            {
                                array0.Add(item0.GetString());
                            }
                            array.Add(array0);
                        }
                    }
                    requiredInputFieldsSets = array;
                    continue;
                }
                if (property.NameEquals("entitiesFilter"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    entitiesFilter = BinaryData.FromString(property.Value.GetRawText());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new InsightQueryItemProperties(
                dataTypes ?? new ChangeTrackingList<EntityQueryItemPropertiesDataTypesItem>(),
                inputEntityType,
                requiredInputFieldsSets ?? new ChangeTrackingList<IList<string>>(),
                entitiesFilter,
                serializedAdditionalRawData,
                displayName,
                description,
                baseQuery,
                tableQuery,
                chartQuery,
                additionalQuery,
                defaultTimeRange,
                referenceTimeRange);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DisplayName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  displayName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DisplayName))
                {
                    builder.Append("  displayName: ");
                    if (DisplayName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{DisplayName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{DisplayName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Description), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  description: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Description))
                {
                    builder.Append("  description: ");
                    if (Description.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Description}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Description}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(BaseQuery), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  baseQuery: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(BaseQuery))
                {
                    builder.Append("  baseQuery: ");
                    if (BaseQuery.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{BaseQuery}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{BaseQuery}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TableQuery), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  tableQuery: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TableQuery))
                {
                    builder.Append("  tableQuery: ");
                    BicepSerializationHelpers.AppendChildObject(builder, TableQuery, options, 2, false, "  tableQuery: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ChartQuery), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  chartQuery: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ChartQuery))
                {
                    builder.Append("  chartQuery: ");
                    builder.AppendLine($"'{ChartQuery.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AdditionalQuery), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  additionalQuery: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AdditionalQuery))
                {
                    builder.Append("  additionalQuery: ");
                    BicepSerializationHelpers.AppendChildObject(builder, AdditionalQuery, options, 2, false, "  additionalQuery: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DefaultTimeRange), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  defaultTimeRange: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DefaultTimeRange))
                {
                    builder.Append("  defaultTimeRange: ");
                    BicepSerializationHelpers.AppendChildObject(builder, DefaultTimeRange, options, 2, false, "  defaultTimeRange: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("BeforeRange", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  referenceTimeRange: ");
                builder.AppendLine("{");
                builder.Append("    beforeRange: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(ReferenceTimeRange))
                {
                    builder.Append("  referenceTimeRange: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ReferenceTimeRange, options, 2, false, "  referenceTimeRange: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DataTypes), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  dataTypes: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(DataTypes))
                {
                    if (DataTypes.Any())
                    {
                        builder.Append("  dataTypes: ");
                        builder.AppendLine("[");
                        foreach (var item in DataTypes)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  dataTypes: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(InputEntityType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  inputEntityType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(InputEntityType))
                {
                    builder.Append("  inputEntityType: ");
                    builder.AppendLine($"'{InputEntityType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RequiredInputFieldsSets), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  requiredInputFieldsSets: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(RequiredInputFieldsSets))
                {
                    if (RequiredInputFieldsSets.Any())
                    {
                        builder.Append("  requiredInputFieldsSets: ");
                        builder.AppendLine("[");
                        foreach (var item in RequiredInputFieldsSets)
                        {
                            if (item == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            builder.AppendLine("[");
                            foreach (var item0 in item)
                            {
                                if (item0 == null)
                                {
                                    builder.Append("null");
                                    continue;
                                }
                                if (item0.Contains(Environment.NewLine))
                                {
                                    builder.AppendLine("    '''");
                                    builder.AppendLine($"{item0}'''");
                                }
                                else
                                {
                                    builder.AppendLine($"    '{item0}'");
                                }
                            }
                            builder.AppendLine("  ]");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EntitiesFilter), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  entitiesFilter: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EntitiesFilter))
                {
                    builder.Append("  entitiesFilter: ");
                    builder.AppendLine($"'{EntitiesFilter.ToString()}'");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<InsightQueryItemProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InsightQueryItemProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(InsightQueryItemProperties)} does not support writing '{options.Format}' format.");
            }
        }

        InsightQueryItemProperties IPersistableModel<InsightQueryItemProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<InsightQueryItemProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeInsightQueryItemProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(InsightQueryItemProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<InsightQueryItemProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
