// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The status of the hunt. </summary>
    public readonly partial struct HuntStatus : IEquatable<HuntStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HuntStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HuntStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NewValue = "New";
        private const string ActiveValue = "Active";
        private const string ClosedValue = "Closed";
        private const string BacklogValue = "Backlog";
        private const string ApprovedValue = "Approved";

        /// <summary> New. </summary>
        public static HuntStatus New { get; } = new HuntStatus(NewValue);
        /// <summary> Active. </summary>
        public static HuntStatus Active { get; } = new HuntStatus(ActiveValue);
        /// <summary> Closed. </summary>
        public static HuntStatus Closed { get; } = new HuntStatus(ClosedValue);
        /// <summary> Backlog. </summary>
        public static HuntStatus Backlog { get; } = new HuntStatus(BacklogValue);
        /// <summary> Approved. </summary>
        public static HuntStatus Approved { get; } = new HuntStatus(ApprovedValue);
        /// <summary> Determines if two <see cref="HuntStatus"/> values are the same. </summary>
        public static bool operator ==(HuntStatus left, HuntStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HuntStatus"/> values are not the same. </summary>
        public static bool operator !=(HuntStatus left, HuntStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HuntStatus"/>. </summary>
        public static implicit operator HuntStatus(string value) => new HuntStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HuntStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HuntStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
