// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Model for API authentication for GitHub. For this authentication first we need to approve the Router app (Microsoft Security DevOps) to access the GitHub account, Then we only need the InstallationId to get the access token from https://api.github.com/app/installations/{installId}/access_tokens. </summary>
    public partial class GitHubAuthModel : CcpAuthConfig
    {
        /// <summary> Initializes a new instance of <see cref="GitHubAuthModel"/>. </summary>
        public GitHubAuthModel()
        {
            AuthType = CcpAuthType.GitHub;
        }

        /// <summary> Initializes a new instance of <see cref="GitHubAuthModel"/>. </summary>
        /// <param name="authType"> The auth type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="installationId"> The GitHubApp auth installation id. </param>
        internal GitHubAuthModel(CcpAuthType authType, IDictionary<string, BinaryData> serializedAdditionalRawData, string installationId) : base(authType, serializedAdditionalRawData)
        {
            InstallationId = installationId;
            AuthType = authType;
        }

        /// <summary> The GitHubApp auth installation id. </summary>
        [WirePath("installationId")]
        public string InstallationId { get; set; }
    }
}
