// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Get Insights result metadata. </summary>
    internal partial class GetInsightsResultsMetadata
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="GetInsightsResultsMetadata"/>. </summary>
        /// <param name="totalCount"> the total items found for the insights request. </param>
        internal GetInsightsResultsMetadata(int totalCount)
        {
            TotalCount = totalCount;
            Errors = new ChangeTrackingList<GetInsightsErrorKind>();
        }

        /// <summary> Initializes a new instance of <see cref="GetInsightsResultsMetadata"/>. </summary>
        /// <param name="totalCount"> the total items found for the insights request. </param>
        /// <param name="errors"> information about the failed queries. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal GetInsightsResultsMetadata(int totalCount, IReadOnlyList<GetInsightsErrorKind> errors, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TotalCount = totalCount;
            Errors = errors;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="GetInsightsResultsMetadata"/> for deserialization. </summary>
        internal GetInsightsResultsMetadata()
        {
        }

        /// <summary> the total items found for the insights request. </summary>
        [WirePath("totalCount")]
        public int TotalCount { get; }
        /// <summary> information about the failed queries. </summary>
        [WirePath("errors")]
        public IReadOnlyList<GetInsightsErrorKind> Errors { get; }
    }
}
