// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> the query kind. </summary>
    internal readonly partial struct GetInsightsError : IEquatable<GetInsightsError>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="GetInsightsError"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public GetInsightsError(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InsightValue = "Insight";

        /// <summary> Insight. </summary>
        public static GetInsightsError Insight { get; } = new GetInsightsError(InsightValue);
        /// <summary> Determines if two <see cref="GetInsightsError"/> values are the same. </summary>
        public static bool operator ==(GetInsightsError left, GetInsightsError right) => left.Equals(right);
        /// <summary> Determines if two <see cref="GetInsightsError"/> values are not the same. </summary>
        public static bool operator !=(GetInsightsError left, GetInsightsError right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="GetInsightsError"/>. </summary>
        public static implicit operator GetInsightsError(string value) => new GetInsightsError(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is GetInsightsError other && Equals(other);
        /// <inheritdoc />
        public bool Equals(GetInsightsError other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
