// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Model for API authentication for working with service bus or storage account. </summary>
    public partial class GenericBlobSbsAuthModel : CcpAuthConfig
    {
        /// <summary> Initializes a new instance of <see cref="GenericBlobSbsAuthModel"/>. </summary>
        public GenericBlobSbsAuthModel()
        {
            CredentialsConfig = new ChangeTrackingDictionary<string, string>();
            StorageAccountCredentialsConfig = new ChangeTrackingDictionary<string, string>();
            AuthType = CcpAuthType.ServiceBus;
        }

        /// <summary> Initializes a new instance of <see cref="GenericBlobSbsAuthModel"/>. </summary>
        /// <param name="authType"> The auth type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="credentialsConfig"> Credentials for service bus namespace, keyvault uri for access key. </param>
        /// <param name="storageAccountCredentialsConfig"> Credentials for storage account, keyvault uri for access key. </param>
        internal GenericBlobSbsAuthModel(CcpAuthType authType, IDictionary<string, BinaryData> serializedAdditionalRawData, IDictionary<string, string> credentialsConfig, IDictionary<string, string> storageAccountCredentialsConfig) : base(authType, serializedAdditionalRawData)
        {
            CredentialsConfig = credentialsConfig;
            StorageAccountCredentialsConfig = storageAccountCredentialsConfig;
            AuthType = authType;
        }

        /// <summary> Credentials for service bus namespace, keyvault uri for access key. </summary>
        [WirePath("credentialsConfig")]
        public IDictionary<string, string> CredentialsConfig { get; }
        /// <summary> Credentials for storage account, keyvault uri for access key. </summary>
        [WirePath("storageAccountCredentialsConfig")]
        public IDictionary<string, string> StorageAccountCredentialsConfig { get; }
    }
}
