// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Google Cloud Platform request section properties. </summary>
    public partial class GcpRequestProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="GcpRequestProperties"/>. </summary>
        /// <param name="projectId"> The GCP project id. </param>
        /// <param name="subscriptionNames"> The GCP pub/sub subscription names. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="projectId"/> or <paramref name="subscriptionNames"/> is null. </exception>
        public GcpRequestProperties(string projectId, IEnumerable<string> subscriptionNames)
        {
            Argument.AssertNotNull(projectId, nameof(projectId));
            Argument.AssertNotNull(subscriptionNames, nameof(subscriptionNames));

            ProjectId = projectId;
            SubscriptionNames = subscriptionNames.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="GcpRequestProperties"/>. </summary>
        /// <param name="projectId"> The GCP project id. </param>
        /// <param name="subscriptionNames"> The GCP pub/sub subscription names. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal GcpRequestProperties(string projectId, IList<string> subscriptionNames, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProjectId = projectId;
            SubscriptionNames = subscriptionNames;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="GcpRequestProperties"/> for deserialization. </summary>
        internal GcpRequestProperties()
        {
        }

        /// <summary> The GCP project id. </summary>
        [WirePath("projectId")]
        public string ProjectId { get; set; }
        /// <summary> The GCP pub/sub subscription names. </summary>
        [WirePath("subscriptionNames")]
        public IList<string> SubscriptionNames { get; }
    }
}
