// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Represents Google Cloud Platform data connector. </summary>
    public partial class GcpDataConnector : SecurityInsightsDataConnectorData
    {
        /// <summary> Initializes a new instance of <see cref="GcpDataConnector"/>. </summary>
        public GcpDataConnector()
        {
            Kind = DataConnectorKind.GCP;
        }

        /// <summary> Initializes a new instance of <see cref="GcpDataConnector"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> The data connector kind. </param>
        /// <param name="etag"> Etag of the azure resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="connectorDefinitionName"> The name of the connector definition that represents the UI config. </param>
        /// <param name="auth"> The auth section of the connector. </param>
        /// <param name="request"> The request section of the connector. </param>
        /// <param name="dcrConfig"> The configuration of the destination of the data. </param>
        internal GcpDataConnector(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, DataConnectorKind kind, ETag? etag, IDictionary<string, BinaryData> serializedAdditionalRawData, string connectorDefinitionName, GcpAuthProperties auth, GcpRequestProperties request, DcrConfiguration dcrConfig) : base(id, name, resourceType, systemData, kind, etag, serializedAdditionalRawData)
        {
            ConnectorDefinitionName = connectorDefinitionName;
            Auth = auth;
            Request = request;
            DcrConfig = dcrConfig;
            Kind = kind;
        }

        /// <summary> The name of the connector definition that represents the UI config. </summary>
        [WirePath("properties.connectorDefinitionName")]
        public string ConnectorDefinitionName { get; set; }
        /// <summary> The auth section of the connector. </summary>
        [WirePath("properties.auth")]
        public GcpAuthProperties Auth { get; set; }
        /// <summary> The request section of the connector. </summary>
        [WirePath("properties.request")]
        public GcpRequestProperties Request { get; set; }
        /// <summary> The configuration of the destination of the data. </summary>
        [WirePath("properties.dcrConfig")]
        public DcrConfiguration DcrConfig { get; set; }
    }
}
