// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    public partial class GcpAuthProperties : IUtf8JsonSerializable, IJsonModel<GcpAuthProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<GcpAuthProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<GcpAuthProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<GcpAuthProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(GcpAuthProperties)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("serviceAccountEmail"u8);
            writer.WriteStringValue(ServiceAccountEmail);
            writer.WritePropertyName("projectNumber"u8);
            writer.WriteStringValue(ProjectNumber);
            writer.WritePropertyName("workloadIdentityProviderId"u8);
            writer.WriteStringValue(WorkloadIdentityProviderId);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        GcpAuthProperties IJsonModel<GcpAuthProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<GcpAuthProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(GcpAuthProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeGcpAuthProperties(document.RootElement, options);
        }

        internal static GcpAuthProperties DeserializeGcpAuthProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string serviceAccountEmail = default;
            string projectNumber = default;
            string workloadIdentityProviderId = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("serviceAccountEmail"u8))
                {
                    serviceAccountEmail = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("projectNumber"u8))
                {
                    projectNumber = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("workloadIdentityProviderId"u8))
                {
                    workloadIdentityProviderId = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new GcpAuthProperties(serviceAccountEmail, projectNumber, workloadIdentityProviderId, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ServiceAccountEmail), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  serviceAccountEmail: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ServiceAccountEmail))
                {
                    builder.Append("  serviceAccountEmail: ");
                    if (ServiceAccountEmail.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ServiceAccountEmail}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ServiceAccountEmail}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProjectNumber), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  projectNumber: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProjectNumber))
                {
                    builder.Append("  projectNumber: ");
                    if (ProjectNumber.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ProjectNumber}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ProjectNumber}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(WorkloadIdentityProviderId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  workloadIdentityProviderId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(WorkloadIdentityProviderId))
                {
                    builder.Append("  workloadIdentityProviderId: ");
                    if (WorkloadIdentityProviderId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{WorkloadIdentityProviderId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{WorkloadIdentityProviderId}'");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<GcpAuthProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<GcpAuthProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(GcpAuthProperties)} does not support writing '{options.Format}' format.");
            }
        }

        GcpAuthProperties IPersistableModel<GcpAuthProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<GcpAuthProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeGcpAuthProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(GcpAuthProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<GcpAuthProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
