// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Model for API authentication for all GCP kind connectors. </summary>
    public partial class GcpAuthModel : CcpAuthConfig
    {
        /// <summary> Initializes a new instance of <see cref="GcpAuthModel"/>. </summary>
        /// <param name="serviceAccountEmail"> GCP Service Account Email. </param>
        /// <param name="projectNumber"> GCP Project Number. </param>
        /// <param name="workloadIdentityProviderId"> GCP Workload Identity Provider ID. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="serviceAccountEmail"/>, <paramref name="projectNumber"/> or <paramref name="workloadIdentityProviderId"/> is null. </exception>
        public GcpAuthModel(string serviceAccountEmail, string projectNumber, string workloadIdentityProviderId)
        {
            Argument.AssertNotNull(serviceAccountEmail, nameof(serviceAccountEmail));
            Argument.AssertNotNull(projectNumber, nameof(projectNumber));
            Argument.AssertNotNull(workloadIdentityProviderId, nameof(workloadIdentityProviderId));

            ServiceAccountEmail = serviceAccountEmail;
            ProjectNumber = projectNumber;
            WorkloadIdentityProviderId = workloadIdentityProviderId;
            AuthType = CcpAuthType.GCP;
        }

        /// <summary> Initializes a new instance of <see cref="GcpAuthModel"/>. </summary>
        /// <param name="authType"> The auth type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="serviceAccountEmail"> GCP Service Account Email. </param>
        /// <param name="projectNumber"> GCP Project Number. </param>
        /// <param name="workloadIdentityProviderId"> GCP Workload Identity Provider ID. </param>
        internal GcpAuthModel(CcpAuthType authType, IDictionary<string, BinaryData> serializedAdditionalRawData, string serviceAccountEmail, string projectNumber, string workloadIdentityProviderId) : base(authType, serializedAdditionalRawData)
        {
            ServiceAccountEmail = serviceAccountEmail;
            ProjectNumber = projectNumber;
            WorkloadIdentityProviderId = workloadIdentityProviderId;
            AuthType = authType;
        }

        /// <summary> Initializes a new instance of <see cref="GcpAuthModel"/> for deserialization. </summary>
        internal GcpAuthModel()
        {
        }

        /// <summary> GCP Service Account Email. </summary>
        [WirePath("serviceAccountEmail")]
        public string ServiceAccountEmail { get; set; }
        /// <summary> GCP Project Number. </summary>
        [WirePath("projectNumber")]
        public string ProjectNumber { get; set; }
        /// <summary> GCP Workload Identity Provider ID. </summary>
        [WirePath("workloadIdentityProviderId")]
        public string WorkloadIdentityProviderId { get; set; }
    }
}
