// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    public partial class FusionTemplateSubTypeSeverityFilter : IUtf8JsonSerializable, IJsonModel<FusionTemplateSubTypeSeverityFilter>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<FusionTemplateSubTypeSeverityFilter>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<FusionTemplateSubTypeSeverityFilter>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FusionTemplateSubTypeSeverityFilter>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FusionTemplateSubTypeSeverityFilter)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("isSupported"u8);
            writer.WriteBooleanValue(IsSupported);
            if (Optional.IsCollectionDefined(SeverityFilters))
            {
                writer.WritePropertyName("severityFilters"u8);
                writer.WriteStartArray();
                foreach (var item in SeverityFilters)
                {
                    writer.WriteStringValue(item.ToString());
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        FusionTemplateSubTypeSeverityFilter IJsonModel<FusionTemplateSubTypeSeverityFilter>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FusionTemplateSubTypeSeverityFilter>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FusionTemplateSubTypeSeverityFilter)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeFusionTemplateSubTypeSeverityFilter(document.RootElement, options);
        }

        internal static FusionTemplateSubTypeSeverityFilter DeserializeFusionTemplateSubTypeSeverityFilter(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool isSupported = default;
            IList<SecurityInsightsAlertSeverity> severityFilters = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("isSupported"u8))
                {
                    isSupported = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("severityFilters"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SecurityInsightsAlertSeverity> array = new List<SecurityInsightsAlertSeverity>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(new SecurityInsightsAlertSeverity(item.GetString()));
                    }
                    severityFilters = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new FusionTemplateSubTypeSeverityFilter(isSupported, severityFilters ?? new ChangeTrackingList<SecurityInsightsAlertSeverity>(), serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsSupported), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  isSupported: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  isSupported: ");
                var boolValue = IsSupported == true ? "true" : "false";
                builder.AppendLine($"{boolValue}");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SeverityFilters), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  severityFilters: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(SeverityFilters))
                {
                    if (SeverityFilters.Any())
                    {
                        builder.Append("  severityFilters: ");
                        builder.AppendLine("[");
                        foreach (var item in SeverityFilters)
                        {
                            builder.AppendLine($"    '{item.ToString()}'");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<FusionTemplateSubTypeSeverityFilter>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FusionTemplateSubTypeSeverityFilter>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(FusionTemplateSubTypeSeverityFilter)} does not support writing '{options.Format}' format.");
            }
        }

        FusionTemplateSubTypeSeverityFilter IPersistableModel<FusionTemplateSubTypeSeverityFilter>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FusionTemplateSubTypeSeverityFilter>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeFusionTemplateSubTypeSeverityFilter(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(FusionTemplateSubTypeSeverityFilter)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<FusionTemplateSubTypeSeverityFilter>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
