// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    public partial class FusionTemplateSourceSubType : IUtf8JsonSerializable, IJsonModel<FusionTemplateSourceSubType>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<FusionTemplateSourceSubType>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<FusionTemplateSourceSubType>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FusionTemplateSourceSubType>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FusionTemplateSourceSubType)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("sourceSubTypeName"u8);
            writer.WriteStringValue(SourceSubTypeName);
            if (options.Format != "W" && Optional.IsDefined(SourceSubTypeDisplayName))
            {
                writer.WritePropertyName("sourceSubTypeDisplayName"u8);
                writer.WriteStringValue(SourceSubTypeDisplayName);
            }
            writer.WritePropertyName("severityFilter"u8);
            writer.WriteObjectValue(SeverityFilter, options);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        FusionTemplateSourceSubType IJsonModel<FusionTemplateSourceSubType>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FusionTemplateSourceSubType>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FusionTemplateSourceSubType)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeFusionTemplateSourceSubType(document.RootElement, options);
        }

        internal static FusionTemplateSourceSubType DeserializeFusionTemplateSourceSubType(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string sourceSubTypeName = default;
            string sourceSubTypeDisplayName = default;
            FusionTemplateSubTypeSeverityFilter severityFilter = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("sourceSubTypeName"u8))
                {
                    sourceSubTypeName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("sourceSubTypeDisplayName"u8))
                {
                    sourceSubTypeDisplayName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("severityFilter"u8))
                {
                    severityFilter = FusionTemplateSubTypeSeverityFilter.DeserializeFusionTemplateSubTypeSeverityFilter(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new FusionTemplateSourceSubType(sourceSubTypeName, sourceSubTypeDisplayName, severityFilter, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SourceSubTypeName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  sourceSubTypeName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SourceSubTypeName))
                {
                    builder.Append("  sourceSubTypeName: ");
                    if (SourceSubTypeName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{SourceSubTypeName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{SourceSubTypeName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SourceSubTypeDisplayName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  sourceSubTypeDisplayName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SourceSubTypeDisplayName))
                {
                    builder.Append("  sourceSubTypeDisplayName: ");
                    if (SourceSubTypeDisplayName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{SourceSubTypeDisplayName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{SourceSubTypeDisplayName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SeverityFilter), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  severityFilter: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SeverityFilter))
                {
                    builder.Append("  severityFilter: ");
                    BicepSerializationHelpers.AppendChildObject(builder, SeverityFilter, options, 2, false, "  severityFilter: ");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<FusionTemplateSourceSubType>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FusionTemplateSourceSubType>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(FusionTemplateSourceSubType)} does not support writing '{options.Format}' format.");
            }
        }

        FusionTemplateSourceSubType IPersistableModel<FusionTemplateSourceSubType>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FusionTemplateSourceSubType>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeFusionTemplateSourceSubType(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(FusionTemplateSourceSubType)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<FusionTemplateSourceSubType>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
