// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    public partial class FusionTemplateSourceSetting : IUtf8JsonSerializable, IJsonModel<FusionTemplateSourceSetting>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<FusionTemplateSourceSetting>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<FusionTemplateSourceSetting>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FusionTemplateSourceSetting>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FusionTemplateSourceSetting)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("sourceName"u8);
            writer.WriteStringValue(SourceName);
            if (Optional.IsCollectionDefined(SourceSubTypes))
            {
                writer.WritePropertyName("sourceSubTypes"u8);
                writer.WriteStartArray();
                foreach (var item in SourceSubTypes)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        FusionTemplateSourceSetting IJsonModel<FusionTemplateSourceSetting>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FusionTemplateSourceSetting>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FusionTemplateSourceSetting)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeFusionTemplateSourceSetting(document.RootElement, options);
        }

        internal static FusionTemplateSourceSetting DeserializeFusionTemplateSourceSetting(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string sourceName = default;
            IList<FusionTemplateSourceSubType> sourceSubTypes = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("sourceName"u8))
                {
                    sourceName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("sourceSubTypes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<FusionTemplateSourceSubType> array = new List<FusionTemplateSourceSubType>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(FusionTemplateSourceSubType.DeserializeFusionTemplateSourceSubType(item, options));
                    }
                    sourceSubTypes = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new FusionTemplateSourceSetting(sourceName, sourceSubTypes ?? new ChangeTrackingList<FusionTemplateSourceSubType>(), serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SourceName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  sourceName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SourceName))
                {
                    builder.Append("  sourceName: ");
                    if (SourceName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{SourceName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{SourceName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SourceSubTypes), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  sourceSubTypes: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(SourceSubTypes))
                {
                    if (SourceSubTypes.Any())
                    {
                        builder.Append("  sourceSubTypes: ");
                        builder.AppendLine("[");
                        foreach (var item in SourceSubTypes)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  sourceSubTypes: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<FusionTemplateSourceSetting>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FusionTemplateSourceSetting>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(FusionTemplateSourceSetting)} does not support writing '{options.Format}' format.");
            }
        }

        FusionTemplateSourceSetting IPersistableModel<FusionTemplateSourceSetting>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FusionTemplateSourceSetting>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeFusionTemplateSourceSetting(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(FusionTemplateSourceSetting)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<FusionTemplateSourceSetting>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
