// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Represents a supported source subtype configuration under a source signal in Fusion detection. </summary>
    public partial class FusionSourceSubTypeSetting
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FusionSourceSubTypeSetting"/>. </summary>
        /// <param name="isEnabled"> Determines whether this source subtype under source signal is enabled or disabled in Fusion detection. </param>
        /// <param name="sourceSubTypeName"> The Name of the source subtype under a given source signal in Fusion detection. Refer to Fusion alert rule template for supported values. </param>
        /// <param name="severityFilters"> Severity configuration for a source subtype consumed in fusion detection. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sourceSubTypeName"/> or <paramref name="severityFilters"/> is null. </exception>
        public FusionSourceSubTypeSetting(bool isEnabled, string sourceSubTypeName, FusionSubTypeSeverityFilter severityFilters)
        {
            Argument.AssertNotNull(sourceSubTypeName, nameof(sourceSubTypeName));
            Argument.AssertNotNull(severityFilters, nameof(severityFilters));

            IsEnabled = isEnabled;
            SourceSubTypeName = sourceSubTypeName;
            SeverityFilters = severityFilters;
        }

        /// <summary> Initializes a new instance of <see cref="FusionSourceSubTypeSetting"/>. </summary>
        /// <param name="isEnabled"> Determines whether this source subtype under source signal is enabled or disabled in Fusion detection. </param>
        /// <param name="sourceSubTypeName"> The Name of the source subtype under a given source signal in Fusion detection. Refer to Fusion alert rule template for supported values. </param>
        /// <param name="sourceSubTypeDisplayName"> The display name of source subtype under a source signal consumed in Fusion detection. </param>
        /// <param name="severityFilters"> Severity configuration for a source subtype consumed in fusion detection. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FusionSourceSubTypeSetting(bool isEnabled, string sourceSubTypeName, string sourceSubTypeDisplayName, FusionSubTypeSeverityFilter severityFilters, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsEnabled = isEnabled;
            SourceSubTypeName = sourceSubTypeName;
            SourceSubTypeDisplayName = sourceSubTypeDisplayName;
            SeverityFilters = severityFilters;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="FusionSourceSubTypeSetting"/> for deserialization. </summary>
        internal FusionSourceSubTypeSetting()
        {
        }

        /// <summary> Determines whether this source subtype under source signal is enabled or disabled in Fusion detection. </summary>
        [WirePath("enabled")]
        public bool IsEnabled { get; set; }
        /// <summary> The Name of the source subtype under a given source signal in Fusion detection. Refer to Fusion alert rule template for supported values. </summary>
        [WirePath("sourceSubTypeName")]
        public string SourceSubTypeName { get; set; }
        /// <summary> The display name of source subtype under a source signal consumed in Fusion detection. </summary>
        [WirePath("sourceSubTypeDisplayName")]
        public string SourceSubTypeDisplayName { get; }
        /// <summary> Severity configuration for a source subtype consumed in fusion detection. </summary>
        [WirePath("severityFilters")]
        public FusionSubTypeSeverityFilter SeverityFilters { get; set; }
    }
}
