// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    public partial class FusionSourceSubTypeSetting : IUtf8JsonSerializable, IJsonModel<FusionSourceSubTypeSetting>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<FusionSourceSubTypeSetting>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<FusionSourceSubTypeSetting>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FusionSourceSubTypeSetting>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FusionSourceSubTypeSetting)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("enabled"u8);
            writer.WriteBooleanValue(IsEnabled);
            writer.WritePropertyName("sourceSubTypeName"u8);
            writer.WriteStringValue(SourceSubTypeName);
            if (options.Format != "W" && Optional.IsDefined(SourceSubTypeDisplayName))
            {
                writer.WritePropertyName("sourceSubTypeDisplayName"u8);
                writer.WriteStringValue(SourceSubTypeDisplayName);
            }
            writer.WritePropertyName("severityFilters"u8);
            writer.WriteObjectValue(SeverityFilters, options);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        FusionSourceSubTypeSetting IJsonModel<FusionSourceSubTypeSetting>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FusionSourceSubTypeSetting>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FusionSourceSubTypeSetting)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeFusionSourceSubTypeSetting(document.RootElement, options);
        }

        internal static FusionSourceSubTypeSetting DeserializeFusionSourceSubTypeSetting(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool enabled = default;
            string sourceSubTypeName = default;
            string sourceSubTypeDisplayName = default;
            FusionSubTypeSeverityFilter severityFilters = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("enabled"u8))
                {
                    enabled = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("sourceSubTypeName"u8))
                {
                    sourceSubTypeName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("sourceSubTypeDisplayName"u8))
                {
                    sourceSubTypeDisplayName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("severityFilters"u8))
                {
                    severityFilters = FusionSubTypeSeverityFilter.DeserializeFusionSubTypeSeverityFilter(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new FusionSourceSubTypeSetting(enabled, sourceSubTypeName, sourceSubTypeDisplayName, severityFilters, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsEnabled), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  enabled: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  enabled: ");
                var boolValue = IsEnabled == true ? "true" : "false";
                builder.AppendLine($"{boolValue}");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SourceSubTypeName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  sourceSubTypeName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SourceSubTypeName))
                {
                    builder.Append("  sourceSubTypeName: ");
                    if (SourceSubTypeName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{SourceSubTypeName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{SourceSubTypeName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SourceSubTypeDisplayName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  sourceSubTypeDisplayName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SourceSubTypeDisplayName))
                {
                    builder.Append("  sourceSubTypeDisplayName: ");
                    if (SourceSubTypeDisplayName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{SourceSubTypeDisplayName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{SourceSubTypeDisplayName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SeverityFilters), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  severityFilters: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SeverityFilters))
                {
                    builder.Append("  severityFilters: ");
                    BicepSerializationHelpers.AppendChildObject(builder, SeverityFilters, options, 2, false, "  severityFilters: ");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<FusionSourceSubTypeSetting>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FusionSourceSubTypeSetting>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(FusionSourceSubTypeSetting)} does not support writing '{options.Format}' format.");
            }
        }

        FusionSourceSubTypeSetting IPersistableModel<FusionSourceSubTypeSetting>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FusionSourceSubTypeSetting>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeFusionSourceSubTypeSetting(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(FusionSourceSubTypeSetting)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<FusionSourceSubTypeSetting>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
