// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Represents a Fusion scenario exclusion patterns in Fusion detection. </summary>
    public partial class FusionScenarioExclusionPattern
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FusionScenarioExclusionPattern"/>. </summary>
        /// <param name="exclusionPattern"> Scenario exclusion pattern. </param>
        /// <param name="dateAddedInUTC"> DateTime when scenario exclusion pattern is added in UTC. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="exclusionPattern"/> or <paramref name="dateAddedInUTC"/> is null. </exception>
        public FusionScenarioExclusionPattern(string exclusionPattern, string dateAddedInUTC)
        {
            Argument.AssertNotNull(exclusionPattern, nameof(exclusionPattern));
            Argument.AssertNotNull(dateAddedInUTC, nameof(dateAddedInUTC));

            ExclusionPattern = exclusionPattern;
            DateAddedInUTC = dateAddedInUTC;
        }

        /// <summary> Initializes a new instance of <see cref="FusionScenarioExclusionPattern"/>. </summary>
        /// <param name="exclusionPattern"> Scenario exclusion pattern. </param>
        /// <param name="dateAddedInUTC"> DateTime when scenario exclusion pattern is added in UTC. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FusionScenarioExclusionPattern(string exclusionPattern, string dateAddedInUTC, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ExclusionPattern = exclusionPattern;
            DateAddedInUTC = dateAddedInUTC;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="FusionScenarioExclusionPattern"/> for deserialization. </summary>
        internal FusionScenarioExclusionPattern()
        {
        }

        /// <summary> Scenario exclusion pattern. </summary>
        [WirePath("exclusionPattern")]
        public string ExclusionPattern { get; set; }
        /// <summary> DateTime when scenario exclusion pattern is added in UTC. </summary>
        [WirePath("dateAddedInUTC")]
        public string DateAddedInUTC { get; set; }
    }
}
