// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The parameters required to execute s timeline operation on the given entity. </summary>
    public partial class EntityTimelineContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EntityTimelineContent"/>. </summary>
        /// <param name="startOn"> The start timeline date, so the results returned are after this date. </param>
        /// <param name="endOn"> The end timeline date, so the results returned are before this date. </param>
        public EntityTimelineContent(DateTimeOffset startOn, DateTimeOffset endOn)
        {
            Kinds = new ChangeTrackingList<EntityTimelineKind>();
            StartOn = startOn;
            EndOn = endOn;
        }

        /// <summary> Initializes a new instance of <see cref="EntityTimelineContent"/>. </summary>
        /// <param name="kinds"> Array of timeline Item kinds. </param>
        /// <param name="startOn"> The start timeline date, so the results returned are after this date. </param>
        /// <param name="endOn"> The end timeline date, so the results returned are before this date. </param>
        /// <param name="numberOfBucket"> The number of bucket for timeline queries aggregation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EntityTimelineContent(IList<EntityTimelineKind> kinds, DateTimeOffset startOn, DateTimeOffset endOn, int? numberOfBucket, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Kinds = kinds;
            StartOn = startOn;
            EndOn = endOn;
            NumberOfBucket = numberOfBucket;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="EntityTimelineContent"/> for deserialization. </summary>
        internal EntityTimelineContent()
        {
        }

        /// <summary> Array of timeline Item kinds. </summary>
        [WirePath("kinds")]
        public IList<EntityTimelineKind> Kinds { get; }
        /// <summary> The start timeline date, so the results returned are after this date. </summary>
        [WirePath("startTime")]
        public DateTimeOffset StartOn { get; }
        /// <summary> The end timeline date, so the results returned are before this date. </summary>
        [WirePath("endTime")]
        public DateTimeOffset EndOn { get; }
        /// <summary> The number of bucket for timeline queries aggregation. </summary>
        [WirePath("numberOfBucket")]
        public int? NumberOfBucket { get; set; }
    }
}
