// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The EntityTemplateQueryKind. </summary>
    public readonly partial struct EntityTemplateQueryKind : IEquatable<EntityTemplateQueryKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EntityTemplateQueryKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EntityTemplateQueryKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActivityValue = "Activity";

        /// <summary> Activity. </summary>
        public static EntityTemplateQueryKind Activity { get; } = new EntityTemplateQueryKind(ActivityValue);
        /// <summary> Determines if two <see cref="EntityTemplateQueryKind"/> values are the same. </summary>
        public static bool operator ==(EntityTemplateQueryKind left, EntityTemplateQueryKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EntityTemplateQueryKind"/> values are not the same. </summary>
        public static bool operator !=(EntityTemplateQueryKind left, EntityTemplateQueryKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EntityTemplateQueryKind"/>. </summary>
        public static implicit operator EntityTemplateQueryKind(string value) => new EntityTemplateQueryKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EntityTemplateQueryKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EntityTemplateQueryKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
