// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The kind of the entity query template. </summary>
    internal readonly partial struct EntityQueryTemplateKind : IEquatable<EntityQueryTemplateKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EntityQueryTemplateKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EntityQueryTemplateKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActivityValue = "Activity";

        /// <summary> Activity. </summary>
        public static EntityQueryTemplateKind Activity { get; } = new EntityQueryTemplateKind(ActivityValue);
        /// <summary> Determines if two <see cref="EntityQueryTemplateKind"/> values are the same. </summary>
        public static bool operator ==(EntityQueryTemplateKind left, EntityQueryTemplateKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EntityQueryTemplateKind"/> values are not the same. </summary>
        public static bool operator !=(EntityQueryTemplateKind left, EntityQueryTemplateKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EntityQueryTemplateKind"/>. </summary>
        public static implicit operator EntityQueryTemplateKind(string value) => new EntityQueryTemplateKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EntityQueryTemplateKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EntityQueryTemplateKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
