// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The EntityQueryKind. </summary>
    public readonly partial struct EntityQueryKind : IEquatable<EntityQueryKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EntityQueryKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EntityQueryKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ExpansionValue = "Expansion";
        private const string ActivityValue = "Activity";

        /// <summary> Expansion. </summary>
        public static EntityQueryKind Expansion { get; } = new EntityQueryKind(ExpansionValue);
        /// <summary> Activity. </summary>
        public static EntityQueryKind Activity { get; } = new EntityQueryKind(ActivityValue);
        /// <summary> Determines if two <see cref="EntityQueryKind"/> values are the same. </summary>
        public static bool operator ==(EntityQueryKind left, EntityQueryKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EntityQueryKind"/> values are not the same. </summary>
        public static bool operator !=(EntityQueryKind left, EntityQueryKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EntityQueryKind"/>. </summary>
        public static implicit operator EntityQueryKind(string value) => new EntityQueryKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EntityQueryKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EntityQueryKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
