// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The entity provider that is synced. </summary>
    public readonly partial struct EntityProvider : IEquatable<EntityProvider>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EntityProvider"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EntityProvider(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveDirectoryValue = "ActiveDirectory";
        private const string AzureActiveDirectoryValue = "AzureActiveDirectory";

        /// <summary> ActiveDirectory. </summary>
        public static EntityProvider ActiveDirectory { get; } = new EntityProvider(ActiveDirectoryValue);
        /// <summary> AzureActiveDirectory. </summary>
        public static EntityProvider AzureActiveDirectory { get; } = new EntityProvider(AzureActiveDirectoryValue);
        /// <summary> Determines if two <see cref="EntityProvider"/> values are the same. </summary>
        public static bool operator ==(EntityProvider left, EntityProvider right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EntityProvider"/> values are not the same. </summary>
        public static bool operator !=(EntityProvider left, EntityProvider right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EntityProvider"/>. </summary>
        public static implicit operator EntityProvider(string value) => new EntityProvider(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EntityProvider other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EntityProvider other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
