// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    public partial class EntityInsightItem : IUtf8JsonSerializable, IJsonModel<EntityInsightItem>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<EntityInsightItem>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<EntityInsightItem>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EntityInsightItem>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(EntityInsightItem)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(QueryId))
            {
                writer.WritePropertyName("queryId"u8);
                writer.WriteStringValue(QueryId);
            }
            if (Optional.IsDefined(QueryTimeInterval))
            {
                writer.WritePropertyName("queryTimeInterval"u8);
                writer.WriteObjectValue(QueryTimeInterval, options);
            }
            if (Optional.IsDefined(TableQueryResults))
            {
                writer.WritePropertyName("tableQueryResults"u8);
                writer.WriteObjectValue(TableQueryResults, options);
            }
            if (Optional.IsCollectionDefined(ChartQueryResults))
            {
                writer.WritePropertyName("chartQueryResults"u8);
                writer.WriteStartArray();
                foreach (var item in ChartQueryResults)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        EntityInsightItem IJsonModel<EntityInsightItem>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EntityInsightItem>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(EntityInsightItem)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeEntityInsightItem(document.RootElement, options);
        }

        internal static EntityInsightItem DeserializeEntityInsightItem(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string queryId = default;
            EntityInsightItemQueryTimeInterval queryTimeInterval = default;
            InsightsTableResult tableQueryResults = default;
            IReadOnlyList<InsightsTableResult> chartQueryResults = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("queryId"u8))
                {
                    queryId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("queryTimeInterval"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    queryTimeInterval = EntityInsightItemQueryTimeInterval.DeserializeEntityInsightItemQueryTimeInterval(property.Value, options);
                    continue;
                }
                if (property.NameEquals("tableQueryResults"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    tableQueryResults = InsightsTableResult.DeserializeInsightsTableResult(property.Value, options);
                    continue;
                }
                if (property.NameEquals("chartQueryResults"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<InsightsTableResult> array = new List<InsightsTableResult>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(InsightsTableResult.DeserializeInsightsTableResult(item, options));
                    }
                    chartQueryResults = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new EntityInsightItem(queryId, queryTimeInterval, tableQueryResults, chartQueryResults ?? new ChangeTrackingList<InsightsTableResult>(), serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(QueryId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  queryId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(QueryId))
                {
                    builder.Append("  queryId: ");
                    if (QueryId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{QueryId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{QueryId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(QueryTimeInterval), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  queryTimeInterval: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(QueryTimeInterval))
                {
                    builder.Append("  queryTimeInterval: ");
                    BicepSerializationHelpers.AppendChildObject(builder, QueryTimeInterval, options, 2, false, "  queryTimeInterval: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TableQueryResults), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  tableQueryResults: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TableQueryResults))
                {
                    builder.Append("  tableQueryResults: ");
                    BicepSerializationHelpers.AppendChildObject(builder, TableQueryResults, options, 2, false, "  tableQueryResults: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ChartQueryResults), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  chartQueryResults: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(ChartQueryResults))
                {
                    if (ChartQueryResults.Any())
                    {
                        builder.Append("  chartQueryResults: ");
                        builder.AppendLine("[");
                        foreach (var item in ChartQueryResults)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  chartQueryResults: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<EntityInsightItem>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EntityInsightItem>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(EntityInsightItem)} does not support writing '{options.Format}' format.");
            }
        }

        EntityInsightItem IPersistableModel<EntityInsightItem>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EntityInsightItem>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeEntityInsightItem(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(EntityInsightItem)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<EntityInsightItem>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
