// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The Get Insights result operation response. </summary>
    internal partial class EntityGetInsightsResponse
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EntityGetInsightsResponse"/>. </summary>
        internal EntityGetInsightsResponse()
        {
            Value = new ChangeTrackingList<EntityInsightItem>();
        }

        /// <summary> Initializes a new instance of <see cref="EntityGetInsightsResponse"/>. </summary>
        /// <param name="metaData"> The metadata from the get insights operation results. </param>
        /// <param name="value"> The insights result values. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EntityGetInsightsResponse(GetInsightsResultsMetadata metaData, IReadOnlyList<EntityInsightItem> value, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MetaData = metaData;
            Value = value;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The metadata from the get insights operation results. </summary>
        [WirePath("metaData")]
        public GetInsightsResultsMetadata MetaData { get; }
        /// <summary> The insights result values. </summary>
        [WirePath("value")]
        public IReadOnlyList<EntityInsightItem> Value { get; }
    }
}
