// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Settings with single toggle. </summary>
    public partial class EntityAnalytics : SecurityInsightsSettingData
    {
        /// <summary> Initializes a new instance of <see cref="EntityAnalytics"/>. </summary>
        public EntityAnalytics()
        {
            EntityProviders = new ChangeTrackingList<EntityProvider>();
            Kind = SettingKind.EntityAnalytics;
        }

        /// <summary> Initializes a new instance of <see cref="EntityAnalytics"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> The kind of the setting. </param>
        /// <param name="etag"> Etag of the azure resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="entityProviders"> The relevant entity providers that are synced. </param>
        internal EntityAnalytics(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, SettingKind kind, ETag? etag, IDictionary<string, BinaryData> serializedAdditionalRawData, IList<EntityProvider> entityProviders) : base(id, name, resourceType, systemData, kind, etag, serializedAdditionalRawData)
        {
            EntityProviders = entityProviders;
            Kind = kind;
        }

        /// <summary> The relevant entity providers that are synced. </summary>
        [WirePath("properties.entityProviders")]
        public IList<EntityProvider> EntityProviders { get; }
    }
}
