// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The EnrichmentType. </summary>
    public readonly partial struct EnrichmentType : IEquatable<EnrichmentType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EnrichmentType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EnrichmentType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MainValue = "main";

        /// <summary> main. </summary>
        public static EnrichmentType Main { get; } = new EnrichmentType(MainValue);
        /// <summary> Determines if two <see cref="EnrichmentType"/> values are the same. </summary>
        public static bool operator ==(EnrichmentType left, EnrichmentType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EnrichmentType"/> values are not the same. </summary>
        public static bool operator !=(EnrichmentType left, EnrichmentType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EnrichmentType"/>. </summary>
        public static implicit operator EnrichmentType(string value) => new EnrichmentType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EnrichmentType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EnrichmentType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
