// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    public partial class EnrichmentDomainWhoisContacts : IUtf8JsonSerializable, IJsonModel<EnrichmentDomainWhoisContacts>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<EnrichmentDomainWhoisContacts>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<EnrichmentDomainWhoisContacts>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EnrichmentDomainWhoisContacts>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(EnrichmentDomainWhoisContacts)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Admin))
            {
                writer.WritePropertyName("admin"u8);
                writer.WriteObjectValue(Admin, options);
            }
            if (Optional.IsDefined(Billing))
            {
                writer.WritePropertyName("billing"u8);
                writer.WriteObjectValue(Billing, options);
            }
            if (Optional.IsDefined(Registrant))
            {
                writer.WritePropertyName("registrant"u8);
                writer.WriteObjectValue(Registrant, options);
            }
            if (Optional.IsDefined(Tech))
            {
                writer.WritePropertyName("tech"u8);
                writer.WriteObjectValue(Tech, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        EnrichmentDomainWhoisContacts IJsonModel<EnrichmentDomainWhoisContacts>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EnrichmentDomainWhoisContacts>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(EnrichmentDomainWhoisContacts)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeEnrichmentDomainWhoisContacts(document.RootElement, options);
        }

        internal static EnrichmentDomainWhoisContacts DeserializeEnrichmentDomainWhoisContacts(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            EnrichmentDomainWhoisContact admin = default;
            EnrichmentDomainWhoisContact billing = default;
            EnrichmentDomainWhoisContact registrant = default;
            EnrichmentDomainWhoisContact tech = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("admin"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    admin = EnrichmentDomainWhoisContact.DeserializeEnrichmentDomainWhoisContact(property.Value, options);
                    continue;
                }
                if (property.NameEquals("billing"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    billing = EnrichmentDomainWhoisContact.DeserializeEnrichmentDomainWhoisContact(property.Value, options);
                    continue;
                }
                if (property.NameEquals("registrant"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    registrant = EnrichmentDomainWhoisContact.DeserializeEnrichmentDomainWhoisContact(property.Value, options);
                    continue;
                }
                if (property.NameEquals("tech"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    tech = EnrichmentDomainWhoisContact.DeserializeEnrichmentDomainWhoisContact(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new EnrichmentDomainWhoisContacts(admin, billing, registrant, tech, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Admin), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  admin: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Admin))
                {
                    builder.Append("  admin: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Admin, options, 2, false, "  admin: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Billing), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  billing: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Billing))
                {
                    builder.Append("  billing: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Billing, options, 2, false, "  billing: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Registrant), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  registrant: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Registrant))
                {
                    builder.Append("  registrant: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Registrant, options, 2, false, "  registrant: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Tech), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  tech: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Tech))
                {
                    builder.Append("  tech: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Tech, options, 2, false, "  tech: ");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<EnrichmentDomainWhoisContacts>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EnrichmentDomainWhoisContacts>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(EnrichmentDomainWhoisContacts)} does not support writing '{options.Format}' format.");
            }
        }

        EnrichmentDomainWhoisContacts IPersistableModel<EnrichmentDomainWhoisContacts>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EnrichmentDomainWhoisContacts>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeEnrichmentDomainWhoisContacts(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(EnrichmentDomainWhoisContacts)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<EnrichmentDomainWhoisContacts>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
