// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    internal partial class Dynamics365DataConnectorDataTypesDynamics365CdsActivities : IUtf8JsonSerializable, IJsonModel<Dynamics365DataConnectorDataTypesDynamics365CdsActivities>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<Dynamics365DataConnectorDataTypesDynamics365CdsActivities>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<Dynamics365DataConnectorDataTypesDynamics365CdsActivities>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<Dynamics365DataConnectorDataTypesDynamics365CdsActivities>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(Dynamics365DataConnectorDataTypesDynamics365CdsActivities)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
        }

        Dynamics365DataConnectorDataTypesDynamics365CdsActivities IJsonModel<Dynamics365DataConnectorDataTypesDynamics365CdsActivities>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<Dynamics365DataConnectorDataTypesDynamics365CdsActivities>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(Dynamics365DataConnectorDataTypesDynamics365CdsActivities)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDynamics365DataConnectorDataTypesDynamics365CdsActivities(document.RootElement, options);
        }

        internal static Dynamics365DataConnectorDataTypesDynamics365CdsActivities DeserializeDynamics365DataConnectorDataTypesDynamics365CdsActivities(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            SecurityInsightsDataTypeConnectionState state = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("state"u8))
                {
                    state = new SecurityInsightsDataTypeConnectionState(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new Dynamics365DataConnectorDataTypesDynamics365CdsActivities(state, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(State), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  state: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  state: ");
                builder.AppendLine($"'{State.ToString()}'");
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<Dynamics365DataConnectorDataTypesDynamics365CdsActivities>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<Dynamics365DataConnectorDataTypesDynamics365CdsActivities>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(Dynamics365DataConnectorDataTypesDynamics365CdsActivities)} does not support writing '{options.Format}' format.");
            }
        }

        Dynamics365DataConnectorDataTypesDynamics365CdsActivities IPersistableModel<Dynamics365DataConnectorDataTypesDynamics365CdsActivities>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<Dynamics365DataConnectorDataTypesDynamics365CdsActivities>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDynamics365DataConnectorDataTypesDynamics365CdsActivities(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(Dynamics365DataConnectorDataTypesDynamics365CdsActivities)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<Dynamics365DataConnectorDataTypesDynamics365CdsActivities>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
