// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Represents Dynamics365 data connector. </summary>
    public partial class Dynamics365DataConnector : SecurityInsightsDataConnectorData
    {
        /// <summary> Initializes a new instance of <see cref="Dynamics365DataConnector"/>. </summary>
        public Dynamics365DataConnector()
        {
            Kind = DataConnectorKind.Dynamics365;
        }

        /// <summary> Initializes a new instance of <see cref="Dynamics365DataConnector"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> The data connector kind. </param>
        /// <param name="etag"> Etag of the azure resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="tenantId"> The tenant id to connect to, and get the data from. </param>
        /// <param name="dynamics365CdsActivities"> Common Data Service data type connection. </param>
        internal Dynamics365DataConnector(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, DataConnectorKind kind, ETag? etag, IDictionary<string, BinaryData> serializedAdditionalRawData, Guid? tenantId, Dynamics365DataConnectorDataTypesDynamics365CdsActivities dynamics365CdsActivities) : base(id, name, resourceType, systemData, kind, etag, serializedAdditionalRawData)
        {
            TenantId = tenantId;
            Dynamics365CdsActivities = dynamics365CdsActivities;
            Kind = kind;
        }

        /// <summary> The tenant id to connect to, and get the data from. </summary>
        [WirePath("properties.tenantId")]
        public Guid? TenantId { get; set; }
        /// <summary> Common Data Service data type connection. </summary>
        internal Dynamics365DataConnectorDataTypesDynamics365CdsActivities Dynamics365CdsActivities { get; set; }
        /// <summary> Describe whether this data type connection is enabled or not. </summary>
        [WirePath("properties.dynamics365CdsActivities.state")]
        public SecurityInsightsDataTypeConnectionState? Dynamics365CdsActivitiesState
        {
            get => Dynamics365CdsActivities is null ? default(SecurityInsightsDataTypeConnectionState?) : Dynamics365CdsActivities.State;
            set
            {
                Dynamics365CdsActivities = value.HasValue ? new Dynamics365DataConnectorDataTypesDynamics365CdsActivities(value.Value) : null;
            }
        }
    }
}
